<?php $__env->startSection('content'); ?>
<a href="<?php echo e(route('courses')); ?>" class="btn btn-info btn-sm">
    <i class="fa fa-arrow-left"></i>
    <span>Back</span>
</a>
<div class="mt-2 mb-3 d-lg-flex justify-content-lg-between">
    <div>
        <h1 class="title1  d-inline mr-4">Lessons </h1>
        <h3>Course Title: <span class="font-weight-bolder"><?php echo e($course->course_title); ?></span> </h3>
    </div>
    <div class="mt-3 mt-lg-0">
        <?php if ($lessons and !count($lessons) == 0) : ?>
            <button class="btn btn-light shadow-sm px-3 border" type="button" data-toggle="modal" data-target="#lessonModal">
                <i class=" fa fa-plus"></i>
                New Lesson
            </button>
        <?php endif; ?>
    </div>

</div>
<?php if (isset($component)) {
    $__componentOriginal431821226313d25f12c6b9e5d4f97b7033ed596e = $component;
} ?>
<?php $component = $__env->getContainer()->make(App\View\Components\Admin\Alert::class, []); ?>
<?php $component->withName('admin.alert'); ?>
<?php if ($component->shouldRender()) : ?>
    <?php $__env->startComponent($component->resolveView(), $component->data()); ?>
    <?php $component->withAttributes([]); ?>
    <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal431821226313d25f12c6b9e5d4f97b7033ed596e)) : ?>
    <?php $component = $__componentOriginal431821226313d25f12c6b9e5d4f97b7033ed596e; ?>
    <?php unset($__componentOriginal431821226313d25f12c6b9e5d4f97b7033ed596e); ?>
<?php endif; ?>
<div class="mt-2 mb-5 row">

    <?php $__empty_1 = true;
    $__currentLoopData = $lessons;
    $__env->addLoop($__currentLoopData);
    foreach ($__currentLoopData as $less) : $__env->incrementLoopIndices();
        $loop = $__env->getLastLoop();
        $__empty_1 = false; ?>
        <div class="col-md-4">
            <div class="card ">
                <img src="<?php echo e(str_starts_with($less->thumbnail, 'http') ? $less->thumbnail : asset('storage/app/public/' . $less->thumbnail)); ?>" class="card-img-top" alt="course image">
                <div class="card-body">
                    <h4 class=" font-weight-bolder"><?php echo e($loop->iteration); ?>.
                        <?php echo e($less->title); ?>

                    </h4>
                    <div class="d-flex justify-content-between align-items-center mt-2">
                        <a href="#" class="btn btn-primary btn-sm px-2" data-toggle="modal" data-target="#lessonModal<?php echo e($less->id); ?>">Edit Lesson</a>

                        <div class="d-flex align-items-center ">
                            <i class="mr-1 fa fa-clock"></i>
                            <span> <?php echo e($less->length); ?></span>
                        </div>
                    </div>
                    <a href="#" class="btn btn-danger btn-sm px-2 btn-block mt-3" data-toggle="modal" data-target="#lessonDeleteModal<?php echo e($less->id); ?>">Delete Lesson</a>
                </div>
            </div>
        </div>
        <!-- Modal -->
        <div class="modal fade" tabindex="-1" id="lessonModal<?php echo e($less->id); ?>" aria-h6ledby="exampleModalh6" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header ">
                        <h3 class="mb-2 d-inline ">Update Lesson</h3>
                        <button type="button" class="close " data-dismiss="modal" aria-h6="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body ">
                        <div>
                            <form method="POST" action="<?php echo e(route('updatedlesson')); ?>" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PATCH'); ?>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <h6 class="">Lesson Title</h6>
                                        <input type="text" class="form-control border border-primary" value="<?php echo e($less->title); ?>" name="title" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h6 class="">Length of video</h6>
                                        <input type="text" class="form-control border border-primary" name="length" value="<?php echo e($less->length); ?>" required>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <h6 class="">Description</h6>
                                        <textarea name="desc" cols="4" class="form-control border border-primary ckeditor" required>
                                            <?php echo e($less->description); ?>

                                        </textarea>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h6 class="">Video Link</h6>
                                        <input type="text" class="form-control border border-primary" name="videolink" value="<?php echo e($less->video_link); ?>" required>
                                        <small>
                                            Note: only accepting the "src attribute" value of an Iframe link
                                        </small>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <h6 class="">Allow Preview</h6>
                                        <select name="preview" class="form-control border border-primary">
                                            <option value="<?php echo e($less->locked); ?>">
                                                <?php echo e($less->locked); ?></option>
                                            <option value="true">true</option>
                                            <option value="false">false</option>
                                        </select>
                                        <small>
                                            If you want users to be
                                            able to view this lesson before
                                            purchase
                                        </small>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h6 class="">Lesson Thumbnail (File)</h6>
                                        <input type="file" class="form-control border border-primary" name="image">
                                        <?php $__errorArgs = ['image'];
                                        $__bag = $errors->getBag($__errorArgs[1] ?? 'default');
                                        if ($__bag->has($__errorArgs[0])) :
                                            if (isset($message)) {
                                                $__messageOriginal = $message;
                                            }
                                            $message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="alert alert-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
                                            if (isset($__messageOriginal)) {
                                                $message = $__messageOriginal;
                                            }
                                        endif;
                                        unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h6 class="">Lesson Thumbnail (Url)</h6>
                                        <input type="text" class="form-control border border-primary" name="image_url" value="<?php echo e($less->thumbnail); ?>">
                                    </div>
                                    <h6>
                                        Use either file upload or url to
                                        choose a lesson image, if both is entered, the file upload will be
                                        used.
                                    </h6>
                                    <input type="hidden" value="<?php echo e($less->id); ?>" name="lesson_id">
                                    <input type="hidden" value="<?php echo e($course->id); ?>" name="course_id">
                                </div>
                                <button type="submit" class="px-4 btn btn-primary">Update Lesson</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" tabindex="-1" id="lessonDeleteModal<?php echo e($less->id); ?>" aria-h6ledby="exampleModalh6" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="mb-2 d-inline">Delete Lesson</h3>
                        <button type="button" class="close " data-dismiss="modal" aria-h6="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div>
                            <p class="">Are you sure you want delete this lesson?
                            </p>
                            <a href="<?php echo e(route('deletelesson', ['id' => $less->id, 'courseId' => $course->id])); ?>" class="btn btn-danger">DELETE</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    <?php endforeach;
    $__env->popLoop();
    $loop = $__env->getLastLoop();
    if ($__empty_1) : ?>
        <div class="col-md-12">
            <div class="card text-center py-3">
                <h5 class="">No Lesson for this course</h5>
                <div>
                    <button class="btn btn-secondary px-3" data-toggle="modal" data-target="#lessonModal">Add
                        Lesson</button>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
<!-- Modal -->
<div class="modal fade" tabindex="-1" id="lessonModal" aria-h6ledby="exampleModalh6" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header ">
                <h3 class="mb-2 d-inline ">Add Lesson</h3>
                <button type="button" class="close " data-dismiss="modal" aria-h6="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body ">
                <div>
                    <form method="POST" action="<?php echo e(route('addlesson')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <h6 class="">Lesson Title</h6>
                                <input type="text" class="form-control border border-primary" name="title" required>
                            </div>

                            <div class="form-group col-md-6">
                                <h6 class="">Length of video</h6>
                                <input type="text" class="form-control border border-primary" name="length" required>
                            </div>
                            <div class="form-group col-md-12">
                                <h6 class="">Description</h6>
                                <textarea name="desc" id="" cols="4" class="form-control border border-primary ckeditor" required></textarea>
                            </div>
                            <div class="form-group col-md-6">
                                <h6 class="">Video Link</h6>
                                <input type="text" class="form-control border border-primary" name="videolink" required>
                            </div>
                            <div class="form-group col-md-6">
                                <h6 class="">Allow Preview</h6>
                                <div class="selectgroup">
                                    <label class="selectgroup-item">
                                        <input type="radio" value="true" class="selectgroup-input" name="preview">
                                        <span class="selectgroup-button">Allow</span>
                                    </label>
                                    <label class="selectgroup-item">
                                        <input type="radio" value="false" class="selectgroup-input" name="preview">
                                        <span class="selectgroup-button">Don't Allow</span>
                                    </label>
                                </div>
                            </div>
                            <div class="form-group col-md-6">
                                <h6 class="">Lesson Thumbnail (File)</h6>
                                <input type="file" class="form-control border border-primary" name="image">
                                <?php $__errorArgs = ['image'];
                                $__bag = $errors->getBag($__errorArgs[1] ?? 'default');
                                if ($__bag->has($__errorArgs[0])) :
                                    if (isset($message)) {
                                        $__messageOriginal = $message;
                                    }
                                    $message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
                                    if (isset($__messageOriginal)) {
                                        $message = $__messageOriginal;
                                    }
                                endif;
                                unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group col-md-6">
                                <h6 class="">Lesson Thumbnail (Url)</h6>
                                <input type="text" class="form-control border border-primary" name="image_url">
                            </div>
                            <h6>
                                Use either file upload or url to
                                choose a lesson image, if both is entered, the file upload will be used.
                            </h6>
                            <input type="hidden" value="<?php echo e($course->id); ?>" name="course_id">
                        </div>
                        <button type="submit" class="px-4 btn btn-primary">Add Lesson</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<script src="//cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $('.ckeditor').ckeditor();
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/macbookair/Documents/Brynamics/OnlineTrader/onlinetrade/resources/views/admin/memebership/lessons.blade.php ENDPATH**/ ?>